// background.js
chrome.runtime.onInstalled.addListener(() => {
  chrome.sidePanel.setPanelBehavior({ openPanelOnActionClick: true });
});

// 拡張アイコンをクリックしたタブごとにサイドパネルを開く
chrome.action.onClicked.addListener(async (tab) => {
  try {
    await chrome.sidePanel.open({ tabId: tab.id });
  } catch (error) {
    console.error('サイドパネルを開けませんでした:', error);
  }
});

// コンテンツスクリプトからの関連キーワード取得結果を受け取り、
// サイドパネル（＝元ポップアップ UI）へブロードキャスト
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'relatedKeywordsExtracted') {
    chrome.runtime.sendMessage({
      action: 'relatedKeywordsUpdated',
      keywords: request.keywords,
      url: request.url
    }).catch(() => {
      // サイドパネルがまだ開いていない場合などは無視
    });
  }
  return true;
});